-- Easy interpolation functions
--
-- Unlike easing.lua, these interpolation functions use a single time parameter
-- to make them easy to use. Instead of worrying about beginning and end, you
-- pass your progress value in and get a modified progress value. Then you can
-- use that to lerp between your begin and end values. Lerp more than number
-- values: if you have a lerp for Quat, Color, etc, then you can use these to
-- interpolate.
--
-- Code generated by this modified version of flux's function generator:
--~ --[[
--~ This library is free software; you can redistribute it and/or modify it
--~ under the terms of the MIT license:
--~ Copyright (c) 2016 rxi
--~
--~ Permission is hereby granted, free of charge, to any person obtaining a copy of
--~ this software and associated documentation files (the "Software"), to deal in
--~ the Software without restriction, including without limitation the rights to
--~ use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
--~ of the Software, and to permit persons to whom the Software is furnished to do
--~ so, subject to the following conditions:
--~
--~ The above copyright notice and this permission notice shall be included in all
--~ copies or substantial portions of the Software.
--~
--~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
--~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
--~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
--~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
--~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
--~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
--~ SOFTWARE.
--~ --]]
--~
--~ local iterator = require "util/iterator"
--~ local flux = { _version = "0.1.5" }
--~ flux.easing = { linear = "(p)\nreturn p\nend" }
--~ local easing = {
--~     quad    = "p * p",
--~     cubic   = "p * p * p",
--~     quart   = "p * p * p * p",
--~     quint   = "p * p * p * p * p",
--~     expo    = "2 ^ (10 * (p - 1))",
--~     sine    = "-math.cos(p * (math.pi * .5)) + 1",
--~     circ    = "-(math.sqrt(1 - (p * p)) - 1)",
--~     back    = "p * p * (2.7 * p - 1.7)",
--~     elastic = "-(2^(10 * (p - 1)) * math.sin((p - 1.075) * (math.pi * 2) / .3))"
--~ }
--~ local makefunc = function(str, expr)
--~     return ("(p)\n" .. str:gsub("%$e", expr) .. " end")
--~ end
--~ for k, v in pairs(easing) do
--~     flux.easing[k .. "in"] = makefunc("return $e\n", v)
--~     flux.easing[k .. "out"] = makefunc([[
--~     p = 1 - p
--~     return 1 - ($e)
--~   ]], v)
--~     flux.easing[k .. "inout"] = makefunc([[
--~     p = p * 2
--~     if p < 1 then
--~       return .5 * ($e)
--~     else
--~       p = 2 - p
--~       return .5 * (1 - ($e)) + .5
--~     end
--~   ]], v)
--~ end
--~ print('local ease = {}')
--~ for key,val in iterator.sorted_pairs(flux.easing) do
--~     print('function ease.'..key..val)
--~ end
--~ print('return ease')

local ease = {}
function ease.backin(p)
    return p * p * (2.7 * p - 1.7)
end
function ease.backinout(p)
    p = p * 2
    if p < 1 then
        return .5 * (p * p * (2.7 * p - 1.7))
    else
        p = 2 - p
        return .5 * (1 - (p * p * (2.7 * p - 1.7))) + .5
    end
end
function ease.backout(p)
    p = 1 - p
    return 1 - (p * p * (2.7 * p - 1.7))
end
function ease.circin(p)
    return -(math.sqrt(1 - (p * p)) - 1)
end
function ease.circinout(p)
    p = p * 2
    if p < 1 then
        return .5 * (-(math.sqrt(1 - (p * p)) - 1))
    else
        p = 2 - p
        return .5 * (1 - (-(math.sqrt(1 - (p * p)) - 1))) + .5
    end
end
function ease.circout(p)
    p = 1 - p
    return 1 - (-(math.sqrt(1 - (p * p)) - 1))
end
function ease.cubicin(p)
    return p * p * p
end
function ease.cubicinout(p)
    p = p * 2
    if p < 1 then
        return .5 * (p * p * p)
    else
        p = 2 - p
        return .5 * (1 - (p * p * p)) + .5
    end
end
function ease.cubicout(p)
    p = 1 - p
    return 1 - (p * p * p)
end
function ease.elasticin(p)
    return -(2^(10 * (p - 1)) * math.sin((p - 1.075) * (math.pi * 2) / .3))
end
function ease.elasticinout(p)
    p = p * 2
    if p < 1 then
        return .5 * (-(2^(10 * (p - 1)) * math.sin((p - 1.075) * (math.pi * 2) / .3)))
    else
        p = 2 - p
        return .5 * (1 - (-(2^(10 * (p - 1)) * math.sin((p - 1.075) * (math.pi * 2) / .3)))) + .5
    end
end
function ease.elasticout(p)
    p = 1 - p
    return 1 - (-(2^(10 * (p - 1)) * math.sin((p - 1.075) * (math.pi * 2) / .3)))
end
function ease.expoin(p)
    return 2 ^ (10 * (p - 1))
end
function ease.expoinout(p)
    p = p * 2
    if p < 1 then
        return .5 * (2 ^ (10 * (p - 1)))
    else
        p = 2 - p
        return .5 * (1 - (2 ^ (10 * (p - 1)))) + .5
    end
end
function ease.expoout(p)
    p = 1 - p
    return 1 - (2 ^ (10 * (p - 1)))
end
function ease.linear(p)
    return p
end
function ease.quadin(p)
    return p * p
end
function ease.quadinout(p)
    p = p * 2
    if p < 1 then
        return .5 * (p * p)
    else
        p = 2 - p
        return .5 * (1 - (p * p)) + .5
    end
end
function ease.quadout(p)
    p = 1 - p
    return 1 - (p * p)
end
function ease.quartin(p)
    return p * p * p * p
end
function ease.quartinout(p)
    p = p * 2
    if p < 1 then
        return .5 * (p * p * p * p)
    else
        p = 2 - p
        return .5 * (1 - (p * p * p * p)) + .5
    end
end
function ease.quartout(p)
    p = 1 - p
    return 1 - (p * p * p * p)
end
function ease.quintin(p)
    return p * p * p * p * p
end
function ease.quintinout(p)
    p = p * 2
    if p < 1 then
        return .5 * (p * p * p * p * p)
    else
        p = 2 - p
        return .5 * (1 - (p * p * p * p * p)) + .5
    end
end
function ease.quintout(p)
    p = 1 - p
    return 1 - (p * p * p * p * p)
end
function ease.sinein(p)
    return -math.cos(p * (math.pi * .5)) + 1
end
function ease.sineinout(p)
    p = p * 2
    if p < 1 then
        return .5 * (-math.cos(p * (math.pi * .5)) + 1)
    else
        p = 2 - p
        return .5 * (1 - (-math.cos(p * (math.pi * .5)) + 1)) + .5
    end
end
function ease.sineout(p)
    p = 1 - p
    return 1 - (-math.cos(p * (math.pi * .5)) + 1)
end
return ease
